/**
* \file: LibraryEntryPoint.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include <adit_logging.h>
#include <aauto/AditEndpointCommon.h>
#include "AlsaAudioSink.h"
#include "AlsaAudioSource.h"

LOG_DECLARE_CONTEXT(aauto_audio);

using namespace adit::aauto;

#ifndef COMP_GIT_VERSION
#define COMP_GIT_VERSION "aauto_r3_d01 or newer"
#endif

namespace adit { namespace aauto {

AditAudioSink* AlsaAudioSinkCreate(uint8_t inId, MessageRouter* inRouter)
{
    if(inRouter == nullptr)
    {
        LOG_ERROR((aauto_audio, "MessageRouter pointer is null"));
        return nullptr;
    }
    
    return new AlsaAudioSink(inId, inRouter);
}

AditAudioSource* AlsaAudioSourceCreate(uint8_t inId, MessageRouter* inRouter,
        int inMediaCodecType)
{
    if(inRouter == nullptr)
    {
        LOG_ERROR((aauto_audio, "MessageRouter pointer is null"));
        return nullptr;
    }
    
    return new AlsaAudioSource(inId, inRouter, inMediaCodecType);
}

/*
 * In case the library is linked at compile time it is more convenient to call unique functions
 * rather than the generic plug-in versions.
 */

void AlsaEntryPoint(FactoryRegisterFn inFactoryRegisterFn)
{
    LOG_REGISTER_CONTEXT(aauto_audio, "AUD", "AAUTO audio-endpoint");
    LOGD_DEBUG((aauto_audio, "aauto-alsa git tag: %s", COMP_GIT_VERSION));

    if (inFactoryRegisterFn != nullptr)
    {
        // it is not required to use the factory
        inFactoryRegisterFn("AlsaAudioSink", FactoryAudioSink,
                (CreatorFn)AlsaAudioSinkCreate);
        inFactoryRegisterFn("AlsaAudioSource", FactoryAudioSource,
                (CreatorFn)AlsaAudioSourceCreate);
    }
}

void AlsaExitPoint()
{
    LOG_UNREGISTER_CONTEXT(aauto_audio);
}

} } // namespace adit { namespace aauto {

extern "C" void aauto_LibraryEntryPoint(FactoryRegisterFn inFactoryRegisterFn)
{
    AlsaEntryPoint(inFactoryRegisterFn);
}

extern "C" void aauto_LibraryExitPoint()
{
    AlsaExitPoint();
}
